% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_trast.R
\name{trast}
\alias{trast}
\alias{make_trast}
\alias{make_trast.track_xy}
\title{Create a template raster layer}
\usage{
make_trast(x, ...)

\method{make_trast}{track_xy}(x, factor = 1.5, res = max(c(extent_max(x)/100, 1e-09)), ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{factor}{\verb{[numeric(1)=1.5]\{>= 1\}}\cr Factor by which the extent of the relocations is extended.}

\item{res}{\verb{[numeric(1)]}\cr Resolution of the output raster.}
}
\value{
A \code{RasterLayer} without values.
}
\description{
For some home-range estimation methods (e.g., KDE) a template raster is needed. This functions helps to quickly create such a template raster.
}
