% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{rankslopegraph}
\alias{rankslopegraph}
\title{Rank Slopegraph}
\usage{
rankslopegraph(df, names, group, force.grouping = TRUE, line.size = 1,
  line.alpha = 0.5, line.col = NULL, point.size = 1,
  point.alpha = 0.5, point.col = NULL, text.size = 2,
  legend.position = "bottom")
}
\arguments{
\item{df}{A data frame of records.}

\item{names}{The name of the column having the names of the records.}

\item{group}{Optional. The name of the column with a grouping variable.}

\item{force.grouping}{If \code{TRUE}, the column specified in the argument
\code{names} will be considered as a grouping variable for plotting the
slopegraphs. (Each record will be represented by a different colour).
Default is \code{TRUE}.}

\item{line.size}{Size of lines plotted. Must be numeric.}

\item{line.alpha}{Transparency of lines plotted. Must be
numeric.}

\item{line.col}{Default is \code{TRUE}. Overrides colouring by
\code{force.grouping} argument.}

\item{point.size}{Size of points plotted. Must be numeric.}

\item{point.alpha}{Transparency of points plotted. Must be
numeric.}

\item{point.col}{Default is \code{TRUE}. Overrides colouring by
\code{force.grouping} argument.}

\item{text.size}{Size of text annotations plotted. Must be
numeric.}

\item{legend.position}{Position of the legend in the plot.}
}
\value{
The slopegraph as a \code{ggplot2} grob.
}
\description{
Create a slopegraph or bump chart from a data frame of ranks.
}
\examples{
library(agricolae)
data(soil)

dec <- c("pH", "EC")
inc <- c("CaCO3", "MO", "CIC", "P", "K", "sand",
         "slime", "clay", "Ca", "Mg", "K2", "Na", "Al_H", "K_Mg", "Ca_Mg",
         "B", "Cu", "Fe", "Mn", "Zn")

soilrank <- rankdf(soil, increasing = inc, decreasing = dec)
soilrank
soilslopeg <- rankslopegraph(soilrank, names = "place")
soilslopeg
}
\references{
\insertRef{tufte_visual_1986}{ammistability}
}
