% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_list_data.R
\name{amf_list_data}
\alias{amf_list_data}
\title{Get BASE data variable availability}
\usage{
amf_list_data(site_set = NULL, var_set = NULL)
}
\arguments{
\item{site_set}{A scalar or vector of character specifying the target
AmeriFlux Site ID (CC-Sss). If not specified, it returns all sites.}

\item{var_set}{A scalar or vector of character specifying the target
variables as in basename. See AmeriFlux
page\url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/#base}
for a list of variable names. If not specified, it returns all variables.}
}
\value{
A data frame of variable-specific data availability (per year)
 for selected AmeriFlux sites.
\itemize{
  \item Site_ID - Six character site identifier (CC-Sss)
  \item VARIABLE - Variable name of the data included in the BASE file
  \item BASENAME - Variable base name of the data included in the BASE file.
  \item GAP_FILLED - Whether a variable is a gap-filled variable (TRUE/FALSE)
  \item Y1990 - Percentage of data availability in the year 1990 (0-1).
  \item Y1991 - Percentage of data availability in the year 1991 (0-1).
  \item Y1992 - Percentage of data availability in the year 1992 (0-1).
  \item ...
  }
}
\description{
This function obtains the BASE data availability for all or
selected AmeriFlux sites. See AmeriFlux page
\url{https://ameriflux.lbl.gov/data/aboutdata/data-variables/} for details
about the variable naming.
}
\examples{
\dontrun{
# obtain the data variable availability for all sites
data_aval <- amf_list_data()

# obtain the data variable availability for selected sites
data_aval <- amf_list_data(site_set = c("US-CRT","US-WPT"))

# obtain the data variable availability for selected variables
data_aval <- amf_list_data(var_set = c("FCH4", "WTD"))

}
}
