% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ame_rep}
\alias{ame_rep}
\title{AME model fitting routine for replicated relational data}
\usage{
ame_rep(Y,Xdyad=NULL, Xrow=NULL, Xcol=NULL, rvar = !(model=="rrl")
, cvar = TRUE, dcor = TRUE, R = 0, model="nrm",
intercept=!is.element(model,c("rrl","ord")),
odmax=rep(max(apply(Y>0,c(1,3),sum,na.rm=TRUE)),nrow(Y[,,1])), seed = 1,
nscan = 50000, burn = 500, odens = 25, plot=TRUE, print = TRUE, gof=TRUE)
}
\arguments{
\item{Y}{an n x n x T array of relational matrix, where the third dimension correponds to replicates (over time, for example). See
model below for various data types.}

\item{Xdyad}{an n x n x pd x T array of covariates}

\item{Xrow}{an n x pr x T array of nodal row covariates}

\item{Xcol}{an n x pc x T array of nodal column covariates}

\item{rvar}{logical: fit row random effects?}

\item{cvar}{logical: fit column random effects?}

\item{dcor}{logical: fit a dyadic correlation?}

\item{R}{integer: dimension of the multiplicative effects (can be zero)}

\item{model}{character: one of "nrm","bin","ord","cbin","frn","rrl" - see
the details below}

\item{intercept}{logical: fit model with an intercept?}

\item{odmax}{a scalar integer or vector of length n giving the maximum
number of nominations that each node may make - used for "frn" and "cbin"
models}

\item{seed}{random seed}

\item{nscan}{number of iterations of the Markov chain (beyond burn-in)}

\item{burn}{burn in for the Markov chain}

\item{odens}{output density for the Markov chain}

\item{plot}{logical: plot results while running?}

\item{print}{logical: print results while running?}

\item{gof}{logical: calculate goodness of fit statistics?}
}
\value{
\item{BETA}{posterior samples of regression coefficients}
\item{SABR}{posterior samples of Cov(a,b) and the dyadic correlation}

\item{APM}{posterior mean of additive row effects a} \item{BPM}{posterior
mean of additive column effects b} \item{U}{posterior mean of multiplicative
row effects u} \item{V}{posterior mean of multiplicative column effects v}
\item{UVPM}{posterior mean of UV} \item{EZ}{estimate of expectation of Z
matrix} \item{YPM}{posterior mean of Y (for imputing missing values)}
\item{GOF}{observed (first row) and posterior predictive (remaining rows)
values of four goodness-of-fit statistics}
}
\description{
An MCMC routine providing a fit to an additive and multiplicative effects
(AME) regression model to replicated relational data of
various types.
}
\details{
This command provides posterior inference for parameters in AME models of
independent replicated relational data, assuming one of six possible data
types/models:

"nrm": A normal AME model.

"bin": A binary probit AME model.

"ord": An ordinal probit AME model. An intercept is not identifiable in this
model.

"cbin": An AME model for censored binary data.  The value of 'odmax'
specifies the maximum number of links each row may have.

"frn": An AME model for fixed rank nomination networks. A higher value of
the rank indicates a stronger relationship. The value of 'odmax' specifies
the maximum number of links each row may have.

"rrl": An AME model based on the row ranks. This is appropriate if the
relationships across rows are not directly comparable in terms of scale. An
intercept, row random effects and row regression effects are not estimable
for this model.
}
\examples{
data(YX_bin_long)
fit<-ame_rep(YX_bin_long$Y,YX_bin_long$X,burn=5,nscan=5,odens=1,model="bin")
# you should run the Markov chain much longer than this
}
\author{
Peter Hoff, Yanjun He
}

