% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routing.R
\name{Routing}
\alias{Routing}
\title{Core Routing Class}
\description{
Core routing class.
Do not use directly, see \link{Ambiorix}, and \link{Router}.
}
\examples{

## ------------------------------------------------
## Method `Routing$get`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Routing$receive`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$receive("hello", function(msg, ws){
 print(msg) # print msg received
 
 # send a message back
 ws$send("hello", "Hello back! (sent from R)")
})

if(interactive())
 app$start()
}
\keyword{export}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{error}}{Error handler.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Routing$new()}}
\item \href{#method-get}{\code{Routing$get()}}
\item \href{#method-put}{\code{Routing$put()}}
\item \href{#method-patch}{\code{Routing$patch()}}
\item \href{#method-delete}{\code{Routing$delete()}}
\item \href{#method-post}{\code{Routing$post()}}
\item \href{#method-options}{\code{Routing$options()}}
\item \href{#method-all}{\code{Routing$all()}}
\item \href{#method-receive}{\code{Routing$receive()}}
\item \href{#method-print}{\code{Routing$print()}}
\item \href{#method-use}{\code{Routing$use()}}
\item \href{#method-get_routes}{\code{Routing$get_routes()}}
\item \href{#method-get_receivers}{\code{Routing$get_receivers()}}
\item \href{#method-get_middleware}{\code{Routing$get_middleware()}}
\item \href{#method-clone}{\code{Routing$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$new(path = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Prefix path.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
GET Method

Add routes to listen to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-put"></a>}}
\if{latex}{\out{\hypertarget{method-put}{}}}
\subsection{Method \code{put()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$put(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PUT Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-patch"></a>}}
\if{latex}{\out{\hypertarget{method-patch}{}}}
\subsection{Method \code{patch()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$patch(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PATCH Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$delete(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
DELETE Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-post"></a>}}
\if{latex}{\out{\hypertarget{method-post}{}}}
\subsection{Method \code{post()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$post(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
POST Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-options"></a>}}
\if{latex}{\out{\hypertarget{method-options}{}}}
\subsection{Method \code{options()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$options(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
OPTIONS Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-all"></a>}}
\if{latex}{\out{\hypertarget{method-all}{}}}
\subsection{Method \code{all()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$all(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
All Methods

Add routes to listen to for all methods \code{GET}, \code{POST}, \code{PUT}, \code{DELETE}, and \code{PATCH}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$receive(name, handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of message.}

\item{\code{handler}}{Function to run when message is received.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Receive Websocket Message
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$receive("hello", function(msg, ws){
 print(msg) # print msg received
 
 # send a message back
 ws$send("hello", "Hello back! (sent from R)")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-use"></a>}}
\if{latex}{\out{\hypertarget{method-use}{}}}
\subsection{Method \code{use()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$use(use)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{Either a router as returned by \link{Router}, a function to use as middleware,
or a \code{list} of functions.
If a function is passed, it must accept two arguments (the request, and the response):
this function will be executed every time the server receives a request.
\emph{Middleware may but does not have to return a response, unlike other methods such as \code{get}}
Note that multiple routers and middlewares can be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Use a router or middleware
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_routes"></a>}}
\if{latex}{\out{\hypertarget{method-get_routes}{}}}
\subsection{Method \code{get_routes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_routes()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the routes
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_receivers"></a>}}
\if{latex}{\out{\hypertarget{method-get_receivers}{}}}
\subsection{Method \code{get_receivers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_receivers()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the receivers
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_middleware"></a>}}
\if{latex}{\out{\hypertarget{method-get_middleware}{}}}
\subsection{Method \code{get_middleware()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_middleware()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get the middleware
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
