% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_grid.R
\name{long_grid}
\alias{long_grid}
\alias{grid_cell}
\alias{as.array.long_grid}
\alias{as.matrix.long_grid}
\alias{as.raster.long_grid}
\alias{slice_at}
\title{Create a long format grid}
\usage{
long_grid(x, y = NULL, z = NULL, t = NULL)

grid_cell(grid, dim, ...)

\method{as.array}{long_grid}(x, value, ...)

\method{as.matrix}{long_grid}(x, value, ...)

\method{as.raster}{long_grid}(x, value, ...)

slice_at(grid, ...)
}
\arguments{
\item{x, y, z, t}{For \code{long_grid()} vectors of grid cell positions for each
dimension. The final dimensionality of the object is determined by how many
arguments are given. For \code{slice_at()} an integer defining the index at the
given dimension to extract.}

\item{grid}{A long_grid object}

\item{dim}{The dimension to get the cell index at, either as an integer or
string.}

\item{...}{Arguments passed on to methods (ignored)}

\item{value}{The unquoted value to use for filling out the array/matrix}
}
\description{
This function creates a 1-4 dimensional grid in long format, with the cell
positions encoded in the \code{x}, \code{y}, \code{z}, and \code{t} columns. A long_cell object
is the base class for the tidy interface to ambient, and allows a very
flexible approach to pattern generation at the expense of slightly lower
performance than the \verb{noise_*} functions that maps directly to the underlying
C++ code.
}
\examples{
grid <- long_grid(1:10, seq(0, 1, length = 6), c(3, 6))

# Get which row each cell belongs to
grid_cell(grid, 2) # equivalent to grid_cell(grid, 'y')

# Convert the long_grid to an array and fill with the x position
as.array(grid, x)

# Extract the first column
slice_at(grid, x = 1)

# Convert the first column to a matrix filled with y position
as.matrix(slice_at(grid, x = 1), y)

}
