% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.forms.R
\name{amber.form}
\alias{amber.form}
\title{Get a form}
\usage{
amber.form(amber, id, study = NULL, query = list())
}
\arguments{
\item{amber}{An Amber object}

\item{id}{Form's name or identifier}

\item{study}{Study name or identifier, optional}

\item{query}{The search query, to desambiguate form lookup by name}
}
\value{
A form object as a named list
}
\description{
Get a form by name or identifier.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.form(a, id = "Adult trauma")
amber.form(a, id = "61e69a22fea2df2f3108b508")
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
