% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.grid.outliers.na}
\alias{intFun.grid.outliers.na}
\title{Set all values outside a range to NA}
\usage{
intFun.grid.outliers.na(x, outlier.neg, outlier.pos)
}
\arguments{
\item{x}{A raster object}

\item{outlier.neg}{A number that presents the lower bound of the interquartile range}

\item{outlier.pos}{A number that presents the upper bound of the interquartile range}
}
\value{
A raster object where all outliers are set to NA
}
\description{
Plotting raster objects that contain extreme outliers lead to
plots where most grid cells are presented by a single color since the color
legend covers the entire range of values. To avoid this, the user may define
upper and lower threshold values, which can then be set to NA and marked as
outliers.
}
\examples{

library(raster)
# create a raster object with outliers
data <- c(runif(98,-10,10), -1000, 1000)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# compute upper and lower threshold values for outliers
threshold.values <- intFun.grid.define.outlier(data, 2)
# Set all values outside the outlier range to NA
outlier.neg <- threshold.values[1]
outlier.pos <- threshold.values[2]
data.no.outliers <- intFun.grid.outliers.na(data, outlier.neg, outlier.pos)
plot(data.no.outliers)

}
\keyword{internal}
