% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.grid.define.outlier}
\alias{intFun.grid.define.outlier}
\title{Upper and lower threshold values that define outliers}
\usage{
intFun.grid.define.outlier(x, y)
}
\arguments{
\item{x}{A raster object}

\item{y}{A number}
}
\value{
An upper and a lower threshold value that enclose a range beyond
which values are considered as outliers.
}
\description{
Plotting raster objects that contain extreme outliers lead to
plots where most grid cells are presented by a single colour since the color
legend covers the entire range of values. To avoid this, the user may define
upper and lower threshold values, which can then be set to NA and marked as
outliers. The threshold values are defined as the interquartile range
multiplied by a user-specified factor.
}
\examples{
library(raster)
# make some data
data <- runif(100,-10,10)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# compute upper and lower threshold values for outliers
threshold.values <- intFun.grid.define.outlier(data, 2)
}
\keyword{internal}
