% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertCoord.R
\name{convertCoord}
\alias{convertCoord}
\title{Convert coordinate from different coordinate systems to AutoNavi system}
\usage{
convertCoord(
  locations,
  key = NULL,
  coordsys = NULL,
  sig = NULL,
  output = NULL,
  to_table = TRUE,
  keep_bad_request = TRUE,
  max_core = NULL
)
}
\arguments{
\item{locations}{Required. \cr
String coordinate point from other coordinate system}

\item{key}{Optional.\cr
Amap Key. \cr
Applied from AutoNavi Map API official website\url{https://lbs.amap.com/dev/}}

\item{coordsys}{Optional.\cr
Coordinate System. \cr
Support: `gps`,`mapbar`,`baidu` and `autonavi`-not convert}

\item{sig}{Optional.\cr
Digital Signature.\cr
How to use this argument? Please check here{https://lbs.amap.com/faq/account/key/72}}

\item{output}{Optional.\cr
 Output Data Structure. \cr
Support JSON and XML. The default value is JSON.}

\item{to_table}{Optional.\cr
Transform response content to data.table.}

\item{keep_bad_request}{Optional.\cr
Keep Bad Request to avoid breaking a workflow, especially meaningful in a batch request}

\item{max_core}{Optional.\cr
A threshold of max cores for parallel operation. There is no need to set a `max_core` generally.
But for some extreme high performance case, like `AMD Threadripper` and `Intel Xeon`,
super multiple-core CPU will meet the limitation of queries per second.}
}
\value{
Returns a JSON, XML or data.table of results containing detailed geocode information. See \url{https://lbs.amap.com/api/webservice/guide/api/convert} for more information.
}
\description{
\Sexpr[results=rd]{lifecycle::badge("experimental")}
This function is a wrap of coordinate convert API of AutoNavi Map Service.\cr
While how to input the origin coordinate is sill unstable and 95\% sure that it will have a breaking change in the future.
Please consider carefully if introduced this function in product environment.
}
\examples{
\dontrun{
library(amapGeocode)

# Before the `convertCoord()` is executed,
# the token should be set by `option(amap_key = 'key')`
# or set by key argument in `convertCoord()`

# get result of converted coordinate system as a data.table
convertCoord('116.481499,39.990475',coordsys = 'gps')
# get result of converted coordinate system as a XML
convertCoord('116.481499,39.990475',coordsys = 'gps', to_table = FALSE)
}

}
\seealso{
\code{\link{convertCoord}}
}
