% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amanida_report.R
\name{amanida_report}
\alias{amanida_report}
\title{Report}
\usage{
amanida_report(
  input_file,
  separator = NULL,
  analysis_type = NULL,
  column_id,
  pvalue_cutoff = NULL,
  fc_cutoff = NULL,
  votecount_lim,
  path = NULL,
  comp_inf = NULL
)
}
\arguments{
\item{input_file}{path to the original dataset in xlsx, xls, csv or txt format}

\item{separator}{indicate the separator used in the input_file parameter}

\item{analysis_type}{indicate if data will be quantitative, qualitative or both. Options are:
\itemize{
\item "quan-qual" for quantitative and qualitative meta-analysis
\item "quan" for quantitative meta-analysis using p-value and fold-change
\item "qual" for qualitative meta-analysis using trend label
}}

\item{column_id}{vector containing columns names to use. It has to be in order identification, p-values, fold-changes, sample size and reference.}

\item{pvalue_cutoff}{numeric value to consider statistical significance}

\item{fc_cutoff}{numeric value to consider significance for effect size}

\item{votecount_lim}{minimum numeric value for vote-counting visualization}

\item{path}{path to the directory where html file is created, otherwise the file will be saved in a temporal folder}

\item{comp_inf}{complete information of compounds from public databases}
}
\value{
an html document saved in the working directory
}
\description{
\code{amanida_report} creates a report from the data using amanida functions
}
\details{
This function uses directly the dataset to create a report with the meta-analysis results. In case of quantitative analysis \code{amanida_report} uses the functions \code{amanida_read} and \code{compute_amanida} for analyse the input data. Then the results are showed using \code{volcano_plot}, \code{explore_plot} and \code{vote_plot}.
}
\examples{
\dontrun{
column_id = c("Compound Name", "P-value", "Fold-change", "N total", "References")
input_file <- getsampleDB()

amanida_report(input_file, separator = ";", column_id, analysis_type = "quan", 
                pvalue_cutoff = 0.05, fc_cutoff = 4, votecount_lim = 2, 
                comp_inf = F)
}

}
