% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feglm.control.R
\name{feglm.control}
\alias{feglm.control}
\title{Set \code{feglm} Control Parameters}
\usage{
feglm.control(dev.tol = 1e-08, step.tol = 1e-08, pseudo.tol = 1e-05,
  rho.tol = 1e-04, iter.max = 100L, trace = 0L, drop.pc = TRUE)
}
\arguments{
\item{dev.tol}{tolerance level for the first stopping condition of the maximization routine. The 
stopping condition is based on the relative change of the deviance in iteration \eqn{r}
and can be expressed as follows: \eqn{(dev_{r - 1} dev_{r}) / dev_{r} < 
tol}{\Delta dev / dev < tol}. Default is \code{1.0e-08}.}

\item{step.tol}{tolerance level for the second stopping condition of the maximization routine. The
stopping condition is based on the euclidean norm of the step size in iteration \eqn{r}
and can be expressed as follows: \eqn{||\boldsymbol{\beta}_{r} - 
\boldsymbol{\beta}_{r - 1}||_{2} < tol}{||\Delta \beta|| < tol}. Default is
\code{1.0e-08}.}

\item{pseudo.tol}{tolerance level for the stopping condition of the \dQuote{pseudo demeaning} algorithm.
The stopping condition is based on the relative change of euclidean norm in iteration \eqn{i} and
can be expressed as follows: \eqn{||\mathbf{v}_{i} - \mathbf{v}_{i - 1}||_{2} < 
tol ||\mathbf{v}_{i - 1}||}{||\Delta v|| / ||v_old|| < tol}. Default is
\code{1.0e-05}.}

\item{rho.tol}{tolerance level for the stephalving in the maximization routine. Stephalving only takes
place if the deviance in iteration \eqn{r} is larger than the one of the previous iteration. If 
this is the case, 
\eqn{||\boldsymbol{\beta}_{r} - \boldsymbol{\beta}_{r - 1}||_{2}}{||\Delta \beta||} is 
halfed until the deviance is less or equal compared to the deviance of the previous iteration. 
Stephalving fails if the the following condition holds: \eqn{\rho < tol}{\rho < tol}, 
where \eqn{\rho}{\rho} is the stepcorrection factor. If stephalving fails the maximization
routine is canceled. Default is \code{1.0e-04}.}

\item{iter.max}{unsigned integer indicating the maximum number of iterations in the maximization
routine.}

\item{trace}{unsigned integer indicating if output should be produced in each iteration. Default is
\code{0}.}

\item{drop.pc}{logical indicating to drop observations that are perfectly classified and hence do not
contribute to the log-likelihood. This option is useful to reduce the computational costs
of the maximization problem, since it reduces the number of observations and does not change the
estimates. Default is \code{TRUE}.}
}
\value{
The function \code{feglm.control} returns a named list of control 
parameters.
}
\description{
Set and change parameters used for fitting \code{feglm}.
}
\seealso{
\code{\link{feglm}}
}
