% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlgorithmHandler.r
\name{getAlgorithmHandler}
\alias{getAlgorithmHandler}
\title{Creates a new Algorithm Handler which registers the onLoad method (which loads the model or other
dependencies for the algorithm) and the apply method which takes in the result of the onLoad method
and the input from the user.}
\usage{
getAlgorithmHandler(applyfunc, onLoadMethod = function() {     NULL },
  pipe = "stdin")
}
\arguments{
\item{applyfunc}{The method that we will call synchronously for each algorithm call. The first argument
it will be called with is the user input, followed with the output of the onLoad function.}

\item{onLoadMethod}{This optional method that is run once when the process first starts. It loads the
data required and other shared state for each algorithm call.}

\item{pipe}{The file which we will read line-by-line to get user input}
}
\value{
A new AlgorithmHandler object
}
\description{
Creates a new Algorithm Handler which registers the onLoad method (which loads the model or other
dependencies for the algorithm) and the apply method which takes in the result of the onLoad method
and the input from the user.
}
\examples{
loadPrefix <- function() { "Hello" }
algorithm <- function(input, prefix) { paste(prefix, input) }

#To create an algorithm that returns "Hello" + input:
algo <- getAlgorithmHandler(algorithm, loadPrefix) 
}
