% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestmatch.r
\name{bestmatch}
\alias{bestmatch}
\title{fuzzy partial matching between a scientific name and a list of possible matches}
\usage{
bestmatch(enteredName, possibleNames, maxErr = 3, trunc = TRUE)
}
\arguments{
\item{enteredName}{Character string with name to check}

\item{possibleNames}{Character vector of possible matches}

\item{maxErr}{maximum number of different bits allowed for a partial match}

\item{trunc}{TRUE/FALSE. if true and no match, retry with last three letters truncated}
}
\value{
a character string with the best match, or 'multiplePartialMatches'
}
\description{
fuzzy partial matching between a scientific name and a list of possible matches
}
\examples{
possibleMatches=c('Viburnum edule','Viburnum acerifolia')
bestmatch(enteredName='Viburnum edulus',possibleNames=possibleMatches)
}
