% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algae_search.R
\name{algae_search}
\alias{algae_search}
\title{Compare a genus and species name against the algaebase online database}
\usage{
algae_search(genus, species = "", long = FALSE)
}
\arguments{
\item{genus}{Character string}

\item{species}{Character string}

\item{long}{if TRUE, returns higher taxonomy (Kingdom through Family)}
}
\value{
A data.frame with the following fields: orig.name (submitted name),
    match.name (best match), genus and species (from the match.name), exact.match (1
    indicates whether there was a perfect match for orig.name. 0 otherwise),
    accepted (1 if the orig.name currently accepted, 0 otherwise),
    synonyms (currently accepted synonyms, if any. For genus-only search, returns
    genera associated with species formerly classified with the orig.name genus)
    Empire,Kingdom,Phylum,Class,Order,Family: character strings with current higher
    taxonomy associated with match.name.
}
\description{
Compare a genus and species name against the algaebase online database
}
\examples{
algae_search(genus='Anabaena',species='flos-aquae',long=FALSE)

}
\seealso{
\url{http://www.algaebase.org} for phytoplankton taxonomy database,
    \url{https://powellcenter.usgs.gov/geisha} for project information.
    Algaebase should be cited separately in any publications using this function:
    <doi:10.7872/crya.v35.iss2.2014.105>
}
