% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{plotMRCATest}
\alias{plotMRCATest}
\title{Plot the results of a founder permutation test}
\usage{
plotMRCATest(data, color = "black", main_title = "MRCA Test",
  style = c("histogram", "cdf"), silent = FALSE, ...)
}
\arguments{
\item{data}{\link{MRCATest} object returned by \link{testMRCA}.}

\item{color}{color of the histogram or lines.}

\item{main_title}{string specifying the plot title.}

\item{style}{type of plot to draw. One of:
\itemize{
  \item \code{"histogram"}:  histogram of the annotation count 
                             distribution with a red dotted line
                             denoting the observed value.
  \item \code{"cdf"}:        cumulative distribution function 
                             of annotation counts with a red dotted 
                             line denoting the observed value and
                             a blue dotted line indicating the 
                             p-value.
}}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotMRCATest} plots the results of a founder permutation test performed with 
\code{testMRCA}.
}
\examples{
\donttest{
# Define example tree set
graphs <- ExampleTrees[1-10]

# Perform MRCA test on isotypes
x <- testMRCA(graphs, "ISOTYPE", nperm=10)

# Plot
plotMRCATest(x, color="steelblue", style="hist")
plotMRCATest(x, style="cdf")
}

}
\seealso{
See \link{testEdges} for performing the test.
}
