% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene.R
\name{countGenes}
\alias{countGenes}
\title{Tabulates V(D)J allele, gene or family usage.}
\usage{
countGenes(data, gene, groups = NULL, copy = NULL, clone = NULL,
  mode = c("gene", "allele", "family"))
}
\arguments{
\item{data}{data.frame with Change-O style columns.}

\item{gene}{column containing allele assignments. Only the first allele in the
column will be considered.}

\item{groups}{columns containing grouping variables. If \code{NULL} do not group.}

\item{copy}{name of the \code{data} column containing copy numbers for each 
sequence. If this value is specified, then total copy abundance
is determined by the sum of copy numbers within each gene.
This argument is ignored if \code{clone} is specified.}

\item{clone}{name of the \code{data} column containing clone identifiers for each 
sequence. If this value is specified, then genes will be counted only
once for each clone. Note, this is accomplished by using the most 
common gene within each \code{clone} identifier. As such,
ambiguous alleles within a clone will not be accurately represented.}

\item{mode}{one of \code{c("gene", "family", "allele")} defining
the degree of specificity regarding allele calls. Determines whether 
to return counts for genes, families or alleles.}
}
\value{
A data.frame summarizing family, gene or allele counts and frequencies 
          with columns:
          \itemize{
            \item \code{GENE}:        name of the family, gene or allele
            \item \code{SEQ_COUNT}:   total number of sequences, or clones, for the gene.
            \item \code{SEQ_FREQ}:    frequency of the gene as a fraction of the total
                                      number of sequences, or clones, within each grouping.
            \item \code{COPY_COUNT}:  sum of the copy counts in the \code{copy} column.
                                      for each gene. Only present if the \code{copy} 
                                      argument is specified.
            \item \code{COPY_FREQ}:   frequency of the gene as a fraction of the total
                                      copy number within each group. Only present if 
                                      the \code{copy} argument is specified.
          }
          Additional columns defined by the \code{groups} argument will also be present.
}
\description{
Determines the count and relative abundance of V(D)J alleles, genes or families within
groups.
}
\examples{
# Without copy numbers
genes <- countGenes(ExampleDb, gene="V_CALL", groups="SAMPLE", mode="family")
genes <- countGenes(ExampleDb, gene="V_CALL", groups="SAMPLE", mode="gene")
genes <- countGenes(ExampleDb, gene="V_CALL", groups="SAMPLE", mode="allele")

# With copy numbers and multiple groups
genes <- countGenes(ExampleDb, gene="V_CALL", groups=c("SAMPLE", "ISOTYPE"), 
                    copy="DUPCOUNT", mode="family")

# Count by clone
genes <- countGenes(ExampleDb, gene="V_CALL", groups=c("SAMPLE", "ISOTYPE"), 
                    clone="CLONE", mode="family")

}

