% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_station_data.R
\name{get_station_data}
\alias{get_station_data}
\title{Download pollution data}
\usage{
get_station_data(criterion, pollutant, year, progress = interactive())
}
\arguments{
\item{criterion}{Type of data to download.
\itemize{
 \item{"HORARIOS"}{ - Hourly data}
 \item{"MAXIMOS""}{ - Daily maximums}
 \item{"MINIMOS"}{ - Daily minimums}
}}

\item{pollutant}{The type of pollutant to download.
\itemize{
 \item{"SO2"}{ - Dioxido de azufre (partes por billon)}
 \item{"CO"}{ - Monoxido de carbono (partes por millon)}
 \item{"NOX"}{ - Oxidos de nitrogeno (partes por billon)}
 \item{"NO2"}{ - Dioxido de nitrogeno (partes por billon)}
 \item{"NO"}{ - Oxido nitrico (partes por billon)}
 \item{"O3"}{ - Ozono (partes por billon)}
 \item{"PM10"}{ - Particulas menores a 10 micrometros (microgramos por metro cubico)}
 \item{"PM25"}{ - Particulas menores a 2.5 micrometros (microgramos por metro cubico)}
 \item{"WSP"}{ - Velocidad del viento (metros por segundo)}
 \item{"WDR"}{ - Direccion del viento (grados)}
 \item{"TMP"}{ - Temperatura ambiente (grados Celsius)}
 \item{"RH"}{ - Humedad relativa (porcentaje)}
}}

\item{year}{a numeric vector containing the years for which to download data (the earliest possible value is 1986)}

\item{progress}{Whether to display a progress bar (TRUE or FALSE). By default it will only display in an interactive session.}
}
\value{
a data.frame with pollution data, when downloading "HORARIOS" the hours correspond the
GMT+6 timezone
}
\description{
retrieve pollution data by station from the air quality server at \url{
http://www.aire.cdmx.gob.mx/estadisticas-consultas/concentraciones/index.php} for 2016 data.
For earlier years the archive files from \url{http://www.aire.cdmx.gob.mx/default.php?opc='aKBhnmI'&opcion=Zg==}
are used
}
\examples{
\dontrun{
## Download daily maximum PM10 data (particulate matter 10 micrometers or less in diameter)
## from 2015 to 2016
df <- get_station_data("MAXIMOS", "PM10", 2015:2016)
head(df)
## Download ozone concentration hourly data for 2016
df2 <- get_station_data("HORARIOS", "O3", 2016)
head(df2)
}
}
