% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset.R
\docType{methods}
\name{window}
\alias{window}
\alias{window-method}
\alias{window,TimeSeries-method}
\title{Time Windows}
\usage{
\S4method{window}{TimeSeries}(x, start = NULL, end = NULL, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeSeries}} object.}

\item{start}{A length-one \code{\link{numeric}} vector specifying the start time of the
period of interest.}

\item{end}{A length-one \code{\link{numeric}} vector specifying the end time of the
period of interest.}

\item{...}{Currently not used.}
}
\value{
A \code{\linkS4class{TimeSeries}} object.
}
\description{
Extracts the subset of the object \code{x} observed between the times \code{start} and
\code{end} (expressed in \emph{rata die}).
}
\examples{
## Create 3 time-series of 100 observations
## Sampled every years starting from 1000 CE
(x <- series(matrix(rnorm(300), 100, 3), time = 1000:1099, calendar = CE()))

## Subset between 1025 and 1050 CE
(y <- window(x, start = 374009, end = 383140))
}
\seealso{
Other tools: 
\code{\link{overlap}()},
\code{\link{span}()},
\code{\link{start}()},
\code{\link{time}()}
}
\author{
N. Frerebeau
}
\concept{tools}
