% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,TimeSeries,missing-method}
\title{Plot Time Series}
\usage{
\S4method{plot}{TimeSeries,missing}(
  x,
  facet = c("multiple", "single"),
  calendar = getOption("aion.calendar"),
  panel = graphics::lines,
  flip = FALSE,
  ncol = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeSeries}} object.}

\item{facet}{A \code{\link{character}} string specifying whether the series should be
plotted separately (with a common time axis) or on a single plot?
It must be one of "\code{multiple}" or "\code{single}". Any unambiguous substring can
be given.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{panel}{A \code{\link{function}} in the form \verb{function(x, y, ...)}
which gives the action to be carried out in each panel of the display.
The default is \code{\link[graphics:lines]{graphics::lines()}}.}

\item{flip}{A \code{\link{logical}} scalar: should the y-axis (ticks and numbering) be
flipped from side 2 (left) to 4 (right) from series to series when \code{facet}
is "\code{multiple}"?}

\item{ncol}{An \code{\link{integer}} specifying the number of columns to use when
\code{facet} is "\code{multiple}". Defaults to 1 for up to 4 series, otherwise to 2.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{...}{Further parameters to be passed to \code{panel}
(e.g. \link[graphics:par]{graphical parameters}).}
}
\value{
\code{plot()} is called for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Plot Time Series
}
\examples{
## Create 6 time-series of 50 observations
## Sampled every two years starting from 2000 BP
X <- series(
  object = matrix(rnorm(300), nrow = 50, ncol = 6),
  time = seq(2000, by = -2, length.out = 50),
  calendar = BP()
)

## Multiple
plot(X) # Default calendar
plot(X, calendar = BP(), flip = TRUE) # BP
plot(X, calendar = b2k(), ncol = 1) # b2k

## Single
plot(X, facet = "single") # CE
plot(X, facet = "single", calendar = BP()) # BP

## Create 6 x 3 time-series of 50 observations
## Sampled every two years starting from 2000 BP
X <- series(
  object = array(rnorm(900), dim = c(50, 6, 3)),
  time = seq(2000, by = 2, length.out = 50),
  calendar = BP()
)
plot(X, calendar = BP(), flip = TRUE) # BP
plot(X, calendar = b2k(), ncol = 1) # b2k

## Graphical parameters
plot(X, lwd = c(1, 2, 3), col = c("#004488", "#DDAA33", "#BB5566"))
plot(X, type = "b", pch = 16, col = c("#004488", "#DDAA33", "#BB5566"))
plot(X, type = "p", pch = c(16, 17, 18), cex = c(1, 2, 3))
}
\seealso{
\code{\link[graphics:plot.default]{graphics::plot()}}

Other plotting tools: 
\code{\link{image}()},
\code{\link{year_axis}()}
}
\author{
N. Frerebeau
}
\concept{plotting tools}
