% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{year_axis}
\alias{year_axis}
\title{Time Series Plotting Functions}
\usage{
year_axis(
  side,
  at = NULL,
  format = c("a", "ka", "Ma", "Ga"),
  labels = TRUE,
  calendar = getOption("aion.last_calendar"),
  current_calendar = getOption("aion.last_calendar"),
  ...
)
}
\arguments{
\item{side}{An \code{\link{integer}} specifying which side of the plot the axis is to
be drawn on. The axis is placed as follows: 1=below, 2=left, 3=above and
4=right.}

\item{at}{A \code{\link{numeric}} vector giving the points at which tick-marks are to
be drawn. If \code{NULL}, tickmark locations are computed.}

\item{format}{A \code{\link{character}} string specifying the prefix.
It should be one of "\code{a}", "\code{ka}", "\code{Ma}" or "\code{Ga}".
If \code{TRUE}, a good guess for an appropriate format is made.}

\item{labels}{A \code{\link{logical}} scalar specifying whether annotations are to be
made at the tickmarks, or a vector of \code{\link{character}} strings to be placed at
the tickpoints.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{current_calendar}{A \code{\linkS4class{TimeScale}} object specifying the calendar
used by the last call to \code{\link[=plot]{plot()}}.}

\item{...}{Further parameters to be passed to \code{\link[graphics:axis]{graphics::axis()}}.
(e.g. \link[graphics:par]{graphical parameters}).}
}
\value{
\code{year_axis()} is called it for its side-effects.
}
\description{
Time Series Plotting Functions
}
\examples{
## Create a time-series of 300 observations
## Sampled every two years starting from 2000 BP
X <- series(
  object = rnorm(300),
  time = seq(2000, by = -2, length.out = 300),
  calendar = BP()
)

## Axis
plot(X, axes = FALSE, calendar = BP()) # Remove axes
year_axis(side = 1) # Same calendar as last plot
year_axis(side = 3, calendar = CE()) # Specific calendar
mtext(format(CE()), side = 3, line = 3)

## Grid
plot(X, panel.first = graphics::grid())
}
\seealso{
Other plotting tools: 
\code{\link{image}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plotting tools}
