% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_compute_nuisance_functions.R
\name{compute_nuisance_functions_ai}
\alias{compute_nuisance_functions_ai}
\title{Fit outcome/decision and propensity score models conditioning on the AI recommendation}
\usage{
compute_nuisance_functions_ai(
  Y,
  D,
  Z,
  A,
  V,
  d_form = D ~ .,
  y_form = Y ~ .,
  ps_form = Z ~ .,
  distribution = "bernoulli",
  n.trees = 1000,
  shrinkage = 0.01,
  interaction.depth = 1,
  ...
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{A}{An AI recommendation (binary: numeric vector of 0 or 1).}

\item{V}{A \code{matrix} of pretreatment covariates for nuisance functions.}

\item{d_form}{A formula for decision model where the dependent variable is \code{D}.}

\item{y_form}{A formula for outcome model where the dependent variable is \code{Y}.}

\item{ps_form}{A formula for propensity score model.}

\item{distribution}{A distribution argument used in \code{gbm} function. Default is \code{"bernoulli"}.}

\item{n.trees}{Integer specifying the total number of trees to fit used in \code{gbm} function.}

\item{shrinkage}{A shrinkage parameter used in \code{gbm} function.}

\item{interaction.depth}{Integer specifying the maximum depth of each tree used in \code{gbm} function.}

\item{...}{Additional arguments to be passed to \code{gbm} function called in \code{crossfit}}
}
\value{
A list with the following components:
\describe{
  \item{\code{z_models}}{A \code{data.frame} with the following columns:
    \describe{
      \item{\code{idx}}{Index of observation.}
      \item{\code{d_pred}}{Predicted probability of decision.}
      \item{\code{y_pred}}{Predicted probability of outcome.}
      \item{\code{Z}}{Treatment group.}
      \item{\code{A}}{AI recommendation.}
    }
  }
  \item{\code{pscore}}{A vector of predicted propensity scores.}
}
}
\description{
Fit (1) the decision model \eqn{m^{D}(z, a, X_i) := \Pr(D = 1 \mid Z = z, A = a, X = X_i)} and
(2) the outcome model \eqn{m^{Y}(z, a, X_i) := \Pr(Y = 1 \mid D = 0, Z = z, A = a, X = X_i)}
for each treatment group \eqn{z \in \{0,1\}} and AI recommendation \eqn{a \in \{0,1\}},
and (3) the propensity score model \eqn{e(1, X_i) := \Pr(Z = 1 \mid X = X_i)}.
}
\examples{
compute_nuisance_functions_ai(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  V = NCAdata[, c("Sex", "White", "Age")],
  shrinkage = 0.01,
  n.trees = 1000
)

}
