% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_discordance.R
\name{TestDiscordance}
\alias{TestDiscordance}
\title{Test assumption of discordance between theoretical and observed study scale.}
\usage{
TestDiscordance(
  n,
  se,
  data,
  study = NULL,
  method = "prop",
  coval = 0.2,
  tot = 0,
  plot = FALSE,
  color = "lightpink"
)
}
\arguments{
\item{n}{NUMERIC values for sample size (n) of each study.}

\item{se}{NUMERIC values for standard error of each study.}

\item{data}{DATA FRAME consists of three columns for study label, sample
size, and standard error.}

\item{study}{CHARACTER for study label of each study.}

\item{method}{CHARACTER of "rank" or "prop" for indicating which method should
be used.}

\item{coval}{NUMERIC value of cutoff point ranged from 0 to 1 in order to
detecting of discordance between theoretical and observed study
scale.}

\item{tot}{NUMERIC value of tolerate discordance in ranks between theoretical
and observed study scale. The numeric value should be ranged
from 0 to 1 / 4 number of studies.}

\item{plot}{LOGIC value for indicating whether to illustrate discordance plot.}

\item{color}{CHARACTER of a color name for emphasizing the studies with
discordance in ranks between theoretical and observed study size.}
}
\value{
\strong{TestDiscordance()} returns a summary of result of discordance in rank of study size.
}
\description{
\strong{TestDiscordance()} is a function for discordance in rank of study size analysis.
}
\examples{
## Not run:
# 1. Import a dataset of study by Fleiss (1993)
library(meta)
data("Fleiss1993bin")
data <- Fleiss1993bin

# 2. Calculate total sample size and standard error of each study
data$n  <- data$n.asp + data$n.plac
data$se <- sqrt((1 / data$d.asp) - (1 / data$n.asp) + (1 / data$d.plac) - (1 / data$n.plac))

# 3. Test discordance in ranks between theoretical and observed study size.
output <- TestDiscordance(n = n, se = se, study = study, data = data)

# 4. Illustrate discordance plot
TestDiscordance(n = n, se = se, study = study, data = data, plot = TRUE)

## End(Not run)

}
\references{
Howell, D. C. (2012). \strong{Statistical methods for psychology (7th ed.)}.
Belmont, CA: Thomson. Available online:
https://labs.la.utexas.edu/gilden/files/2016/05/Statistics-Text.pdf.
}
\seealso{
\code{\link{TestDisparity}}
}
\author{
Enoch Kang
}
