% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp.R
\name{ahp}
\alias{ahp}
\title{Canned routine for AHP}
\usage{
ahp(df, atts, negconvert = FALSE, reciprocal = TRUE,
  method = "eigen", aggmethod = "geometric", qt = 0,
  censorcr = Inf, agg = FALSE)
}
\arguments{
\item{df}{a dataframe, each row corresponding to one decision-maker, with columns ordered according to  \code{atts}.}

\item{atts}{a list of attributes in the correct order}

\item{negconvert}{logical, whether to convert all positive values to
negative. In the pairwise comparison A_B, if -6 denotes A is more
important than B by 6 units, set \code{negconvert = TRUE}.}

\item{reciprocal}{logical, whether to convert negative values (after \code{negconvert}) to its reciprocal. If the comparison A_B where B is more important than A was already entered in its reciprocal (e.g. 1/6), choose \code{reciprocal = FALSE}. When \code{reciprocal = FALSE}, do not set \code{negconvert = TRUE}.}

\item{method}{if \code{method = "eigen"}, the individual priority weights are computed using the Dominant Eigenvalues method described in \insertCite{Saaty2003;textual}{ahpsurvey}. Otherwise, then the priorities are computed based on the averages of normalized values. Basically it normalizes the matrices so that all of the columns add up to 1, and then computes the averages of the row as the priority weights of each attribute. Three modes of finding the averages are available:  \code{arithmetic}: the arithmetic mean; \code{geometric}: the geometric mean (the default); \code{rootmean}: the square root of the sum of the squared value.}

\item{aggmethod}{how to aggregate the individual priorities. By default \code{aggmethod = method}. Apart from the methods offered in \code{method}, \code{aggmethod} also permits three other options: \code{tmean} computes the trimmed arithmetic mean, \code{tgmean} computes the trimmed geometric mean (both with quantiles trimmed based on \code{qt}), and \code{sd} computes the standard deviation from the arithmetic mean. If \code{method = "eigen"} and \code{aggmethod} is not specified, \code{aggmethod} defaults to \code{"geometric"}.}

\item{qt}{specifies the quantile which the top \strong{and} bottom priority weights are trimmed. Used only if \code{aggmethod = 'tmean'} or \code{aggmethod = 'tgmean'}. For example, \code{qt = 0.25} specifies that the aggregation is the arithmetic mean of the values from the 25 to 75 percentile. By default \code{qt = 0}.}

\item{censorcr}{the threshold of censoring observations. All observations with a consistency ratio higher than the specified CR will be dropped from the routine. By default, \code{censorcr = Inf}, i.e. drops no observations.}

\item{agg}{by default, \code{agg = FALSE}, which suppresses the output of Aggregated priorities. If \code{agg = TRUE}, the output will be a list where \code{$AggPref} contains the Aggregated priorities and Standard Deviations.}
}
\value{
If \code{agg = TRUE}, returns a list of the results with two elements, \code{indpref} and \code{aggpref}. \code{$indpref} contains individual preference weight (same as \code{ahp.indpref}), consistency ratios, and the top three most inconsistent pairwise comparisons (same as \code{ahp.pwerror}). \code{$aggpref} contains the Aggregated Priorities and Standard Deviations. Otherwise (i.e. default setting), outputs a \code{data.frame} with only \code{$indpref}.
}
\description{
\code{ahp} is a canned routine that returns a \code{data.frame} of individuals' priorities (based on ahp.indpref), number of missing values, consistency ratios, and top three pairs of inconsistent pairwise comparisons. An optional argument \code{agg} allows the user to generate a data.frame of aggregated priorities alongside individual priorities.
}
\examples{

data(city200)
ahp(df = city200, atts = c('cult', 'fam', 'house', 'jobs', 'trans'), negconvert = TRUE)

}
\references{
\insertRef{Saaty2004}{ahpsurvey}
}
\author{
Frankie Cho
}
