% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdd.R
\name{gdd}
\alias{gdd}
\title{Growing Degree Days}
\usage{
gdd(mx, mn, dates, lati = NULL, iniday, endday)
}
\arguments{
\item{mx}{vector of daily maximum temperature series.}

\item{mn}{vector of daily minimum temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{lati}{(optional) numeric value indicating the latitude of location.}

\item{iniday}{initial date in text format ("YYYY-mm-dd"). If "lati" is defined, "iniday" and "endday" are automatically set.}

\item{endday}{last date in text format ("YYYY-mm-dd"). If "lati" is defined, "iniday" and "endday" are automatically set.}
}
\value{
The sum of growing-degree-days is returned as a numeric value.
}
\description{
Growing Degree Day (GDD) or Winkler index. Useful as a zoning tool to differentiate between grape varieties and climate (Winkler et al. 1974).
}
\details{
Depending on the latitude, the function detects the hemisphere and considers growing season from 1st April to 31st October (northern hemisphere) or from 1st October to 30rd April (southern hemisphere).
}
\examples{

  gdd(mx = daily_tmax,
    mn = daily_tmin,
    dates = seq.Date(as.Date('1981-01-01'),
            as.Date('2010-12-31'), by ='day'),
            lati = 42)

}
\references{
Winkler AJ, Cook JA, Kliwer WM, Lider LA (1974) General viticulture. University of California Press, Berkeley, CA
}
