% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftsrr.R
\name{aftsrr}
\alias{aftsrr}
\title{Accelerated Failure Time with Smooth Rank Regression}
\usage{
aftsrr(formula, data, subset, id = NULL, contrasts = NULL,
  weights = NULL, B = 100, rankWeights = c("gehan", "logrank", "PW",
  "GP", "userdefined"), eqType = c("is", "ns", "mis", "mns"),
  se = c("NULL", "bootstrap", "MB", "ZLCF", "ZLMB", "sHCF", "sHMB",
  "ISCF", "ISMB"), control = list())
}
\arguments{
\item{formula}{a formula expression, of the form \code{response ~ predictors}.
The \code{response} is a \code{Surv} object object with right censoring.
See the documentation of \code{lm}, \code{coxph} and \code{formula} for details.}

\item{data}{an optional data frame in which to interpret the variables
occurring in the \code{formula}.}

\item{subset}{an optional vector specifying a subset of observations
to be used in the fitting process.}

\item{id}{an optional vector used to identify the clusters.
If missing, then each individual row of \code{data} is presumed to
represent a distinct subject.
The length of \code{id} should be the same as the number of observation.}

\item{contrasts}{an optional list.}

\item{weights}{an optional vector of observation weights.}

\item{B}{a numeric value specifies the resampling number.
When \code{B = 0} or \code{se = NULL}, only the beta estimate will be displayed.}

\item{rankWeights}{a character string specifying the type of general weights.
    The following are permitted:
\describe{
  \item{\code{logrank}}{logrank weight}
  \item{\code{gehan}}{Gehan's weight}
  \item{\code{PW}}{Prentice-Wilcoxon weight}
  \item{\code{GP}}{GP class weight}
  \item{\code{userdefined}}{a user defined weight provided as a vector
with length equal to the number of subject. This argument is still under-development.}
}}

\item{eqType}{a character string specifying the type of the
    estimating equation used to obtain the regression parameters.
    The following are permitted:
\describe{
  \item{\code{is}}{Regression parameters are estimated by directly solving the
induced-smoothing estimating equations. This is the default and recommended method.}
  \item{\code{ns}}{Regression parameters are estimated by directly solving the nonsmooth
estimating equations.}
  \item{\code{mis}}{Regression parameters are estimated by iterating the
monotonic smoothed Gehan-based estimating equations. This is typical when
  \code{rankWeights = "PW"} and \code{rankWeights = "GP"}.}
  \item{\code{mns}}{Regression parameters are estimated by iterating the
monotonic non-smoothed Gehan-based estimating equations. This is typical when
  \code{rankWeights = "PW"} and \code{rankWeights = "GP"}.}
}}

\item{se}{a character string specifying the estimating method for the variance-covariance matrix.
  The following are permitted:
\describe{
  \item{\code{NULL}}{if \code{se} is specified as \code{NULL},
the variance-covariance matrix will not be computed.}
  \item{\code{bootstrap}}{nonparametric bootstrap.}
  \item{\code{MB}}{multiplier resampling.}
  \item{\code{ZLCF}}{Zeng and Lin's approach with closed form \eqn{V}, see \bold{Details}.}
  \item{\code{ZLMB}}{Zeng and Lin's approach with empirical \eqn{V}, see \bold{Details}.}
  \item{\code{sHCF}}{Huang's approach with closed form \eqn{V}, see \bold{Details}.}
  \item{\code{sHMB}}{Huang's approach with empirical \eqn{V}, see \bold{Details}.}
  \item{\code{ISCF}}{Johnson and Strawderman's sandwich variance estimates with closed form \eqn{V}, see \bold{Details}.}
  \item{\code{ISMB}}{Johnson and Strawderman's sandwich variance estimates with empirical \eqn{V}, see \bold{Details}.}
}}

\item{control}{controls equation solver, maxiter, tolerance, and resampling variance estimation.
The available equation solvers are \code{BBsolve} and \code{dfsane} of the \pkg{BB} package.
The default algorithm control parameters are used when these functions are called.
However, the monotonicity parameter, \code{M}, can be specified by users via the control list.
When \code{M} is specified, the merit parameter, \code{noimp}, is set at \deqn{10 * M}.
The readers are refered to the \pkg{BB} package for details.
Instead of searching for the zero crossing, options including \code{BBoptim} and \code{optim}
will return solution from maximizing the corresponding objective function.
When \code{se = "bootstrap"} or \code{se = "MB"},
an additional argument \code{parallel = TRUE} can be specified to
enable parallel computation.
The number of CPU cores can be specified with \code{parCl},
the default number of CPU cores is the integer value of \code{detectCores() / 2}.}
}
\value{
\code{aftsrr} returns an object of class "\code{aftsrr}" representing the fit.
An object of class "\code{aftsrr}" is a list containing at least the following components:
\describe{
  \item{beta}{A vector of beta estimates}
  \item{covmat}{A list of covariance estimates}
  \item{convergence}{An integer code indicating type of convergence.}
  \describe{
    \item{0}{indicates successful convergence.}
    \item{1}{indicates that the iteration limit \code{maxit} has been reached.}
    \item{2}{indicates failure due to stagnation.}
    \item{3}{indicates error in function evaluation.}
    \item{4}{is failure due to exceeding 100 step length reductions in line-search.}
    \item{5}{indicates lack of improvement in objective function.}
  }
  \item{bhist}{When \code{variance = "MB"}, \code{bhist} gives the bootstrap samples.}
}
}
\description{
Fits a semiparametric accelerated failure time (AFT) model with rank-based approach.
General weights, additional sampling weights and fast sandwich variance estimations
are also incorporated.
Estimating equations are solved with Barzilar-Borwein spectral method implemented as
\code{BBsolve} in package \pkg{BB}.
}
\details{
When \code{se = "bootstrap"} or \code{se = "MB"}, the variance-covariance matrix
is estimated through a bootstrap fashion.
Bootstrap samples that failed to converge are removed when computing the empirical variance matrix.
When bootstrap is not called, we assume the variance-covariance matrix has a sandwich form
\deqn{\Sigma = A^{-1}V(A^{-1})^T,}
where \eqn{V} is the asymptotic variance of the estimating function and
\eqn{A} is the slope matrix.
In this package, we provide seveal methods to estimate the variance-covariance
matrix via this sandwich form, depending on how \eqn{V} and \eqn{A} are estimated.
Specifically, the asymptotic variance, \eqn{V}, can be estimated by either a
closed-form formulation (\code{CF}) or through bootstrap the estimating equations (\code{MB}).
On the other hand, the methods to estimate the slope matrix \eqn{A} are
the inducing smoothing approach (\code{IS}), Zeng and Lin's approach (\code{ZL}),
and the smoothed Huang's approach (\code{sH}).
}
\examples{
data(kidney, package = "survival")
fit <- aftsrr(Surv(time, status) ~ age + sex, id = id,
              data = kidney, se = c("ISMB", "ZLMB"), B = 10)
fit

data(nwtco, package = "survival")
subinx <- sample(1:nrow(nwtco), 668, replace = FALSE)
nwtco$subcohort <- 0
nwtco$subcohort[subinx] <- 1
pn <- table(nwtco$subcohort)[[2]] / sum(table(nwtco$subcohort))
nwtco$hi <- nwtco$rel + ( 1 - nwtco$rel) * nwtco$subcohort / pn
nwtco$age12 <- nwtco$age / 12
nwtco$study <- nwtco$study - 3
nwtco$histol = nwtco$histol - 1
sub <- nwtco[subinx,]
fit <- aftsrr(Surv(edrel, rel) ~ histol + age12 + study, id = seqno,
              weights = hi, data = sub, B = 10, se = c("ISMB", "ZLMB"),
              subset = stage == 4)
summary(fit)
}
\references{
Chiou, S., Kang, S. and Yan, J. (2014)
Fast Accelerated Failure Time Modeling for Case-Cohort Data. \emph{Statistics and Computing},
\bold{24}(4): 559--568.

Chiou, S., Kang, S. and Yan, J. (2014)
Fitting Accelerated Failure Time Model in Routine Survival Analysis with {R} Package \pkg{Aftgee}.
\emph{Journal of Statistical Software}, \bold{61}(11): 1--23.

Huang, Y. (2002) Calibration Regression of Censored Lifetime Medical Cost.
\emph{Journal of American Statistical Association}, \bold{97}, 318--327.

Johnson, L. M. and Strawderman, R. L. (2009)
Induced Smoothing for the Semiparametric Accelerated Failure Time Model:
Asymptotic and Extensions to Clustered Data. \emph{Biometrika}, \bold{96}, 577 -- 590.

Varadhan, R. and Gilbert, P. (2009)
BB: An R Package for Solving a Large System of Nonlinear Equations and
for Optimizing a High-Dimensional Nonlinear Objective Function.
\emph{Journal of Statistical Software}, \bold{32}(4): 1--26

Zeng, D. and Lin, D. Y. (2008)
Efficient Resampling Methods for Nonsmooth Estimating Functions.
\emph{Biostatistics}, \bold{9}, 355--363
}
