% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle.r
\name{angle}
\alias{angle}
\alias{degrees}
\alias{gradians}
\alias{pi_radians}
\alias{radians}
\alias{turns}
\title{Angle vectors}
\usage{
angle(x = numeric(), unit = getOption("affiner_angular_unit", "degrees"))

degrees(x)

gradians(x)

pi_radians(x)

radians(x)

turns(x)
}
\arguments{
\item{x}{An angle vector or an object to convert to it (such as a numeric vector)}

\item{unit}{A string of the desired angular unit.  Supports the following strings
(note we ignore any punctuation and space characters as well as any trailing \code{s}'s
e.g. "half turns" will be treated as equivalent to "halfturn"):
\itemize{
\item "deg" or "degree"
\item "half-revolution", "half-turn", or "pi-radian"
\item "gon", "grad", "grade", or "gradian"
\item "rad" or "radian"
\item "rev", "revolution", "tr", or "turn"
}}
}
\value{
A numeric vector of class "angle".
Its "unit" attribute is a standardized string of the specified angular unit.
}
\description{
\code{angle()} creates angle vectors with user specified angular unit.
around \code{\link[=as_angle]{as_angle()}} for those angular units.
}
\examples{
  # Different representations of the "same" angle
  angle(180, "degrees")
  angle(pi, "radians")
  angle(0.5, "turns")
  angle(200, "gradians")
  pi_radians(1)

  a1 <- angle(180, "degrees")
  angular_unit(a1)
  is_angle(a1)
  as.numeric(a1, "radians")
  cos(a1)

  a2 <- as_angle(a1, "radians")
  angular_unit(a2)
  is_congruent(a1, a2)
}
\seealso{
\code{\link[=as_angle]{as_angle()}}, \code{\link[=angular_unit]{angular_unit()}}, and \link{angle-methods}.
\url{https://en.wikipedia.org/wiki/Angle#Units} for more information about angular units.
}
