% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_test_norm_local.R
\name{adaptive_analysis_norm_local}
\alias{adaptive_analysis_norm_local}
\title{Analyze data according to a locally efficient adaptive design.}
\usage{
adaptive_analysis_norm_local(overall_sig_level = 0.025, min_effect_size = 1,
  times = 0, stats = 0, final_analysis = TRUE, input_check = TRUE)
}
\arguments{
\item{overall_sig_level}{Overall significance level in (0, 1). Default is 0.025.}

\item{min_effect_size}{The minimum effect size.  It should be positive. The working test will be constructed to have the power of \code{1 - work_beta} for this effect size.  Default is 1.}

\item{times}{The sequence of times (sample size or information level) at which analyses were conducted.}

\item{stats}{The sequence of test statistics.}

\item{final_analysis}{If \code{TRUE}, the result input will be regarded as complete (no more data will be obtained) and the significance level will be exhausted. If \code{FALSE}, the current analysis will be regarded as an interim analysis and the significance level will be preserved.}

\item{input_check}{Indicate whether or not the arguments input by user contain invalid values.}
}
\value{
List of results including the conditional Type I error probability.
}
\description{
\code{adaptive_analysis_norm_local} performs an locally efficient adaptive test, 
a Frequentist adaptive test with the specified significance level
with full flexibility.
Normality with known variance is assumed for the test statistic
(more accurately, the test statistic is assumed to follow Brownian motion.)
Null hypothesis is fixed at 0 without loss of generality.
No procedure to calculate p-value or confidence intervals is employed.
For detailed illustration, see \code{vignette("adpss_ex")}.
}
\examples{
# Sample size calculation
sample_size_norm_local(
  overall_sig_level = 0.025,
  min_effect_size = -log(0.65),
  effect_size = 11.11 / 20.02, # needs not be MLE
  time = 20.02,
  target_power = 0.75,
  sample_size = TRUE
  )
}
\references{
Kashiwabara, K., Matsuyama, Y. An efficient adaptive design approximating fixed sample size designs. In preparation.
}
\seealso{
\code{\link{sample_size_norm_local}}.
}
