% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R, R/AffineScoreFunction.R,
%   R/constraints.R, R/ConditionalPower.R, R/ConditionalSampleSize.R,
%   R/regularization.R
\docType{methods}
\name{evaluate}
\alias{evaluate}
\alias{evaluate,IntegralScore,TwoStageDesign-method}
\alias{evaluate,AffineScore,TwoStageDesign-method}
\alias{evaluate,Constraint,TwoStageDesign-method}
\alias{evaluate,ConstraintsCollection,TwoStageDesign-method}
\alias{evaluate,ConditionalPower,TwoStageDesign-method}
\alias{evaluate,ConditionalSampleSize,TwoStageDesign-method}
\alias{evaluate,AverageN2,TwoStageDesign-method}
\alias{evaluate,N1,TwoStageDesign-method}
\title{Evaluation of a score}
\usage{
evaluate(s, design, ...)

\S4method{evaluate}{IntegralScore,TwoStageDesign}(s, design,
  optimization = FALSE, subdivisions = 10000L, ...)

\S4method{evaluate}{AffineScore,TwoStageDesign}(s, design, ...)

\S4method{evaluate}{Constraint,TwoStageDesign}(s, design,
  optimization = FALSE, ...)

\S4method{evaluate}{ConstraintsCollection,TwoStageDesign}(s, design,
  optimization = FALSE, ...)

\S4method{evaluate}{ConditionalPower,TwoStageDesign}(s, design, x1,
  optimization = FALSE, ...)

\S4method{evaluate}{ConditionalSampleSize,TwoStageDesign}(s, design, x1,
  optimization = FALSE, ...)

\S4method{evaluate}{AverageN2,TwoStageDesign}(s, design,
  optimization = FALSE, subdivisions = 10000L, ...)

\S4method{evaluate}{N1,TwoStageDesign}(s, design, optimization = FALSE,
  ...)
}
\arguments{
\item{s}{score}

\item{design}{\code{TwoStageDesign} object}

\item{...}{further optional arguments}

\item{optimization}{logical, if \code{TRUE} uses a relaxation to real
parameters of the underlying design; used for smooth optimization.}

\item{subdivisions}{integer, number of subdivisions that is used for integration
on the continuation region; results become more precise with increased
number of subdivisions; default is \code{10000L}.}

\item{x1}{stage-one test statistic}
}
\description{
Both \code{\link{ConditionalScore}} as well as
\code{\link{UnconditionalScore}} implement \code{evaluate} methods
which handle the actual computation of the score given a design and
(for conditional scores) an interim result.
}
\details{
The method \code{evaluate} is preimplemented for all preimplemented
   scores in \pkg{adoptr}.
   An example on working with scores is presented
   \href{https://kkmann.github.io/adoptr/articles/score-and-constraints-arithmetic.html}{here}.
}
\examples{
# create a dummy design
design <- TwoStageDesign(50, .0, 2.0, 50, 2.0, order = 5L)

# define type one error als IntegralScore
toer <- expected(ConditionalPower(Normal(), PointMassPrior(.0, 1)))

# evaluate
evaluate(toer, design)

# evaluate affine N1 score
aff_n1 <- N1() + 10
evaluate(
   aff_n1,
   OneStageDesign(50, 1.96)
) # 60

evaluate(
   expected(ConditionalPower(Normal(), PointMassPrior(.0, 1))) <= 0.05,
   OneStageDesign(50, 1.96)
) # -0.025

# define power at delta = 0.3 and type one error rate
pow  <- expected(ConditionalPower(Normal(), PointMassPrior(.3, 1)))
toer <- expected(ConditionalPower(Normal(), PointMassPrior(.0, 1)))
# evaluate if power >= 0.8 and toer <= 0.025
evaluate(
   subject_to(
      pow  >= 0.8,
      toer <= 0.025
   ),
   TwoStageDesign(50.0, 0.0, 2.0, rep(60.0, 5), seq(2.0, 0.0, length.out = 5))
)


# evaluate conditional power
evaluate(
   ConditionalPower(Normal(), PointMassPrior(.3, 1)),
   TwoStageDesign(50, .0, 2.0, 50, 2.0, order = 5L),
   x1 = 1
)

# evaluate conditional sample size
evaluate(
   ConditionalSampleSize(Normal(), PointMassPrior(.3, 1)),
   TwoStageDesign(50, .0, 2.0, 50, 2.0, order = 5L),
   x1 = 3
) # 50

evaluate(
   AverageN2(),
   TwoStageDesign(100, 0.5, 1.5, 60.0, 1.96, order = 5L)
) # 60

evaluate(
   N1(),
   TwoStageDesign(70, 0, 2, rep(60, 6), rep(1.7, 6))
) # 70

}
\seealso{
Conditional scores additionally implement an \code{expected} method
   to obtain the corresponding unconditional \code{\link{IntegralScore}}.
}
