% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContinuousPrior.R
\docType{class}
\name{ContinuousPrior-class}
\alias{ContinuousPrior-class}
\alias{ContinuousPrior}
\alias{show,ContinuousPrior-method}
\title{Continuous univariate prior distributions}
\usage{
ContinuousPrior(pdf, support, tighten_support = FALSE,
  check_normalization = TRUE)

\S4method{show}{ContinuousPrior}(object)
}
\arguments{
\item{pdf}{vectorized univariate PDF function}

\item{support}{numeric vector of length two with the bounds of
the compact interval on which the pdf is positive.}

\item{tighten_support}{logical indicating if the support should be tightened}

\item{check_normalization}{logical indicating if it should be checked
that \code{pdf} defines a density.}

\item{object}{object of class \code{ContinuousPrior}}
}
\description{
\code{ContinuousPrior} is a sub-class of \code{\link{Prior}} implementing
a generic representation of continuous prior distributions over a compact
interval on the real line.
}
\section{Slots}{

\describe{
\item{\code{pdf}}{cf. parameter 'pdf'}

\item{\code{support}}{cf. parameter 'support'}
}}

\examples{
ContinuousPrior(function(x) 2*x, c(0, 1))

}
\seealso{
Discrete priors are supported via \code{\link{PointMassPrior}}
}
