% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthoBasis_coef.R
\name{orthoBasis_coef}
\alias{orthoBasis_coef}
\title{Compute expansion coefficients in a given orthonormal polynomial basis.}
\usage{
orthoBasis_coef(
  data,
  comp.dist = NULL,
  comp.param = NULL,
  supp = c("Real", "Integer", "Positive", "Bounded.continuous"),
  degree,
  m = 3,
  other = NULL
)
}
\arguments{
\item{data}{Observed sample from which the coefficients are calculated. Can be NULL if 'comp.dist' and 'comp.param' are specified.}

\item{comp.dist}{(default to NULL) A list with two elements corresponding to component distributions (specified with
R native names for these distributions) involved in the admixture model.
Unknown elements must be specified as 'NULL' objects (for instance unknown 'f': list(f=NULL, g='norm')).}

\item{comp.param}{(default to NULL) A list with two elements corresponding to the parameters of the component distributions, each
element being a list itself. The names used in this list must correspond to the native R argument names
for these distributions. Unknown elements must be specified as 'NULL' objects.
For instance if 'f' is unknown: list(f = NULL, g = list(mean=0,sd=1)).}

\item{supp}{Support of the density considered.}

\item{degree}{Degree up to which the polynomial basis is built.}

\item{m}{(default to 3) Only used when support is 'Integer'. Corresponds to the mean of the reference measure, i.e. Poisson(m).}

\item{other}{(default to NULL) A list to precise bounds when the support is bounded, where the second and fourth elements give bounds.}
}
\value{
The list composed of 'degree' elements, each element being a numeric vector (with sample size) where each value represents
the k-th order coefficient found when decomposing the density in the orthonormal polynomial basis.
}
\description{
Compute the coefficients corresponding to the decomposition of some density in a given orthonormal polynomial basis.
}
\examples{
## Simulate data:
sample1 <- rnorm(n = 7000, mean = 3, sd = 1)
## Compute the expansion coefficients in the orthonormal polynomial basis:
coeff <- orthoBasis_coef(data = sample1, comp.dist = NULL, comp.param = NULL, supp = 'Real',
                         degree = 3, m = 3, other = NULL)
sapply(coeff, mean)
## No observed data and decomposition of the known component of the admixture model:
coeff <- orthoBasis_coef(data = NULL, comp.dist = list(NULL, 'norm'),
            comp.param=list(NULL,list(mean=3,sd=1)), supp = 'Real', degree=3, m=3, other = NULL)
sapply(coeff, mean)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
