% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_advs_params.R
\name{derive_param_bsa}
\alias{derive_param_bsa}
\title{Adds a Parameter for BSA (Body Surface Area) Using the Specified Method}
\usage{
derive_param_bsa(
  dataset,
  by_vars,
  method,
  set_values_to = vars(PARAMCD = "BSA"),
  height_code = "HEIGHT",
  weight_code = "WEIGHT",
  get_unit_expr,
  filter = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} parameter, \code{PARAMCD}, and
\code{AVAL} are expected.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the input dataset after restricting it by the filter condition (\code{filter}
parameter) and to the parameters specified by \code{HEIGHT} and \code{WEIGHT}.}

\item{by_vars}{Grouping variables

For each group defined by \code{by_vars} an observation is added to the output
dataset.

\emph{Permitted Values:} list of variables}

\item{method}{Derivation method to use. Note that \code{HEIGHT} is expected
in cm and \code{WEIGHT} is expected in kg:

Mosteller: \code{sqrt(height * weight / 3600)}

DuBois-DuBois: \code{0.20247 * (height/100) ^ 0.725 * weight ^ 0.425}

Haycock: \code{0.024265 * height ^ 0.3964 * weight ^ 0.5378}

Gehan-George: \code{0.0235 * height ^ 0.42246 * weight ^ 0.51456}

Boyd: \code{0.0003207 * (height ^ 0.3) * (1000 * weight) ^ (0.7285 - (0.0188 * log10(1000 * weight)))}

Fujimoto: \code{0.008883 * height ^ 0.663 * weight ^ 0.444}

Takahira: \code{0.007241 * height ^ 0.725 * weight ^ 0.425}

Permitted Values: character value}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. For example \code{vars(PARAMCD = "MAP")} defines the parameter
code for the new parameter.

\emph{Permitted Values:} List of variable-value pairs}

\item{height_code}{HEIGHT parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the HEIGHT assessments. It is expected that HEIGHT is measured in cm.

Permitted Values: character value}

\item{weight_code}{WEIGHT parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the WEIGHT assessments. It is expected that WEIGHT is measured in kg.

Permitted Values: character value}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters.

Permitted Values: A variable of the input dataset or a function call}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\emph{Permitted Values:} a condition}
}
\value{
The input dataset with the new parameter added
}
\description{
Adds a record for BSA (Body Surface Area) using the specified derivation method
for each by group (e.g., subject and visit) where the source parameters are available.
}
\examples{
advs <- tibble::tribble(
  ~USUBJID,      ~PARAMCD, ~PARAM,        ~AVAL, ~AVALU, ~VISIT,
  "01-701-1015", "HEIGHT", "Height (cm)", 170,   "cm",   "BASELINE",
  "01-701-1015", "WEIGHT", "Weight (kg)",  75,   "kg",   "BASELINE",
  "01-701-1015", "WEIGHT", "Weight (kg)",  78,   "kg",   "MONTH 1",
  "01-701-1015", "WEIGHT", "Weight (kg)",  80,   "kg",   "MONTH 2",
  "01-701-1028", "HEIGHT", "Height (cm)", 185,   "cm",   "BASELINE",
  "01-701-1028", "WEIGHT", "Weight (kg)",  90,   "kg",   "BASELINE",
  "01-701-1028", "WEIGHT", "Weight (kg)",  88,   "kg",   "MONTH 1",
  "01-701-1028", "WEIGHT", "Weight (kg)",  85,   "kg",   "MONTH 2",
)

derive_param_bsa(
  advs,
  by_vars = vars(USUBJID, VISIT),
  method = "Mosteller",
  get_unit_expr = AVALU
)

derive_param_bsa(
  advs,
  by_vars = vars(USUBJID, VISIT),
  method = "Fujimoto",
  get_unit_expr = extract_unit(PARAM)
)
}
\author{
Eric Simms
}
\keyword{advs}
\keyword{derivation}
