% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptr-package.R
\docType{package}
\name{adaptr-package}
\alias{adaptr-package}
\alias{adaptr}
\title{adaptr: Adaptive Trial Simulator}
\description{
\if{html}{\figure{adaptr.png}{options: align="right" width="120" alt="logo"}}

The \code{adaptr} package simulates adaptive (multi-arm) trials using adaptive
stopping, adaptive arm dropping and/or response-adaptive randomisation.
The package is developed as part of the
\href{https://incept.dk/}{INCEPT (Intensive Care Platform Trial) project},
funded primarily by a grant from
\href{https://www.sygeforsikring.dk/}{Sygeforsikringen "danmark"}.
}
\details{
The \code{adaptr} package contains the following primary functions:
\enumerate{
\item \link{setup_trial} is the general function that sets up a trial specification.
The simpler, special-case functions \link{setup_trial_binom} and
\link{setup_trial_norm} may be used for easier specification of trial designs
using binary, binomially distributed or continuous, normally distributed
outcomes, respectively, with some limitations in flexibility.
\item The \link{run_trial} and \link{run_trials} functions are used to conduct single or
multiple simulations, respectively, according to a trial specification setup
as described in #1.
\item The \link{extract_results} and \link{summary} functions are used to
extract or summarise the results of multiple trial simulations.
\item The \link{plot_status} and \link{plot_history} functions are used to plot the
overall trial/arm statuses for multiple simulated trials or the history of
trial metrics over time for single/multiple simulated trials, respectively.
}

For further information see the function documentation or the \strong{Overview}
vignette (\code{vignette("Overview", package = "adaptr")}) for an example of how
the functions work in combination.
For further examples and guidance on setting up trial specifications, see
\link{setup_trial} documentation, the \strong{Basic examples} vignette
(\code{vignette("Basic-examples", package = "adaptr")}) and the
\strong{Advanced example} vignette
(\code{vignette("Advanced-example", package = "adaptr")}).

If using the package, please consider citing it using
\code{citation(package = "adaptr")}.
}
\references{
\href{https://github.com/INCEPTdk/adaptr/}{GitHub repository}
}
\seealso{
\link{setup_trial}, \link{setup_trial_binom}, \link{setup_trial_norm}, \link{run_trial},
\link{run_trials}, \link{extract_results}, \link{summary}, \link{print}, \link{plot_status} and
\link{plot_history}.
}
