% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceComponents.R
\name{estimateComponents}
\alias{estimateComponents}
\title{Estimate parameters in hierarchical model}
\usage{
estimateComponents(X, Q, Qeig = NULL)
}
\arguments{
\item{X}{An \eqn{n \times p} data matrix.}

\item{Q}{A \eqn{p \times p} matrix giving the prior variance on the
rows of \code{X}.}

\item{Qeig}{If the eigendecomposition of \code{Q} is already computed, it
can be included here.}
}
\value{
A list with \eqn{r} and \eqn{\sigma}.
}
\description{
Estimates the values of \eqn{r} and \eqn{\sigma} in a model \eqn{X \sim N(0, \sigma^2
(r Q + (1 - r)I))}.
}
\examples{
data(AntibioticSmall)
estimateComponents(AntibioticSmall$X, AntibioticSmall$Q)
}
