% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepArchetypesRawData_funct.R
\name{stepArchetypesRawData_funct}
\alias{stepArchetypesRawData_funct}
\title{Archetype algorithm to raw data with the functional Frobenius norm}
\usage{
stepArchetypesRawData_funct(data, numArch, numRep = 3, 
                            verbose = TRUE, saveHistory = FALSE, PM)
}
\arguments{
\item{data}{Data to obtain archetypes.}

\item{numArch}{Number of archetypes to compute, from 1 to \code{numArch}.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{verbose}{If TRUE, the progress during execution is shown.}

\item{saveHistory}{Save execution steps.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}
}
\value{
A list with the archetypes.
}
\description{
This is a slight modification of \code{\link[Anthropometry]{stepArchetypesRawData}}
to use the functional archetype algorithm with the Frobenius norm.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- t(growth$hgtm)
# Create basis:
basis_fd <- create.bspline.basis(c(1,ncol(hgtm)), 10)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:ncol(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = growth$hgtm, basisobj = basis_fd)
data_archs <- t(temp_fd$coefs)

lass <- stepArchetypesRawData_funct(data = data_archs, numArch = 3, 
                                    numRep = 5, verbose = FALSE, 
                                    saveHistory = FALSE, PM)
str(lass)   
length(lass[[1]])
class(lass[[1]])  
class(lass[[1]][[5]])                                 
}                                         

}
\author{
Guillermo Vinue
}
