% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{autotable}
\alias{autotable}
\alias{autotable.exp_df}
\title{Tabular experience study summary}
\usage{
autotable(object, ...)

\method{autotable}{exp_df}(
  object,
  fontsize = 100,
  decimals = 1,
  colorful = TRUE,
  color_q_obs = "RColorBrewer::GnBu",
  color_ae_ = "RColorBrewer::RdBu",
  rename_cols = rlang::list2(...),
  ...
)
}
\arguments{
\item{object}{An object of class \code{exp_df} usually created by the
function \code{exp_stats()}.}

\item{...}{Additional arguments passed to \code{gt::gt()}.}

\item{fontsize}{Font size percentage multiplier.}

\item{decimals}{Number of decimals to display for percentages}

\item{colorful}{If \code{TRUE}, color will be added to the the observed
decrement rate and actual-to-expected columns.}

\item{color_q_obs}{Color palette used for the observed decrement rate.}

\item{color_ae_}{Color palette used for actual-to-expected rates.}

\item{rename_cols}{An optional list consisting of key-value pairs. This
can be used to relabel columns on the output table. Names are column names
in \code{object} and values are new labels. See \code{gt::cols_label()} for
more information.}
}
\value{
a \code{gt} object
}
\description{
\code{autotable} is a generic function used to create a table
from an object of a particular class. Tables are constructed using the
\code{gt} package.

\code{autotable.exp_df} is used to convert experience study results to a
presentation-friendly format.
}
\details{
See \code{paletteer::paletteer_d()}'s \code{palette} argument for usage of
the \code{color_q_obs} and \code{color_ae_} arguments.
}
