% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMMplots.R
\name{comboplot}
\alias{comboplot}
\title{GCMM Combined Plot}
\usage{
comboplot(
  model,
  rug = FALSE,
  ruglwd = 2,
  ltyc = 2,
  ltym = 1,
  lwdc = 3,
  lwdm = 3,
  colc = c("grey40", "grey55", "grey70", "grey85"),
  colm = "black",
  scale = "NULL",
  ymax = "NULL",
  axisunits = c("radians", "sun", "solar", "time", "none"),
  xlines = TRUE
)
}
\arguments{
\item{model}{Model output from \code{\link{GCMM}} function, object of class \code{GCMM}}

\item{rug}{Logical argument for whether to plot a rug of the raw values. Plotting the rug for the separate components requires that saveclustIDs=TRUE when running GCMM. default=FALSE}

\item{ruglwd}{Line width for rug plot}

\item{ltyc}{Line type for activity curves for components}

\item{ltym}{Line type for activity curves for mixture}

\item{lwdc}{Line width for activity curve lines for components}

\item{lwdm}{Line width for activity curve lines from mixture}

\item{colc}{Character vector for colours for the activity curve lines and rug plot for components; must be of equal length to the number of components}

\item{colm}{Character vector for colour of activity curve line from mixture model}

\item{scale}{Scale for the plot, either "pi" (-pi, pi) or "2pi" (0, 2pi); default is that recommended by the GCMM function}

\item{ymax}{Value for upper limit of y-axis}

\item{axisunits}{Scale to use for the xaxis, either "radians", "time", "solar", "sun", or "none"; default="radians"}

\item{xlines}{Whether to include lines on the graph for the x axis labels; default=TRUE}
}
\value{
Prints combined plot of estimated activity curve from mixture model and separate mixture components
}
\description{
Combined plot of estimated activity curve from mixture model and separate mixture components
}
\examples{
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, 
              RE1=redfoxsample$SamplingPeriod, family="vonmises", autorun=FALSE,
              adapt=0, sample=300, burnin=300, thin=1,n.chains=2)
           comboplot(FoxActivityGCMM) }
 
}
