% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{ovl4}
\alias{ovl4}
\title{Index of overlap between circular distributions.}
\usage{
ovl4(fit1, fit2)
}
\arguments{
\item{fit1, fit2}{Fitted activity models of class actmod created using function fitact.}
}
\value{
Scalar overlap index (specifically Dhat4).
}
\description{
Calculates Dhat4 overlap index (see reference) between two kernel distributions.
}
\details{
Uses linear interpolation to impute values from kernel distributions.
}
\examples{
data(BCItime)
oceAct <- fitact(subset(BCItime, species=="ocelot")$time*2*pi)
broAct <- fitact(subset(BCItime, species=="brocket")$time*2*pi)
ovl4(oceAct, broAct)
}
\references{
Ridout, M.S. & Linkie, M. (2009) Estimating overlap of daily activity patterns from camera trap data. Journal of Agricultural Biological and Environmental Statistics, 14, 322-337.
}
