% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_interaction.R
\name{overrideValidityChecks}
\alias{overrideValidityChecks}
\title{Skips all validity checks for a tag and allows the user to freely invalidate events}
\usage{
overrideValidityChecks(moves, detections, tag, GUI, save.tables.locally)
}
\arguments{
\item{moves}{The complete movements table for a specific tag.}

\item{detections}{The detections data.frame for a specific tag.}

\item{tag}{The tag being analysed.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only if the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open and examine that file. Defaults to "needed".}

\item{save.tables.locally}{Logical: If a table must be temporarily stored into a file
for user inspection, should it be saved in the current working directory, or
in R's temporary folder?}
}
\value{
A data frame containing the movements for the target tag
}
\description{
Skips all validity checks for a tag and allows the user to freely invalidate events
}
\keyword{internal}
