% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotSensors}
\alias{plotSensors}
\title{Plot sensor data for a single tag}
\usage{
plotSensors(
  input,
  tag,
  sensor,
  title = tag,
  xlab,
  ylab,
  pcol,
  psize = 1,
  lsize = 0.5,
  colour.by = c("array", "section"),
  array.alias,
  lcol = "grey40",
  verbose = TRUE
)
}
\arguments{
\item{input}{The results of an actel analysis (either explore, migration or residency).}

\item{tag}{The transmitter to be plotted.}

\item{sensor}{The sensors to be plotted. If left empty, all available sensors are plotted}

\item{title}{An optional title for the plot. If left empty, a default title will be added.}

\item{xlab, ylab}{Optional axis names for the plot. If left empty, default axis names will be added.}

\item{pcol}{The colour for the points. If unset, a default palette is used.}

\item{psize}{The size of the points. Defaults to 1.}

\item{lsize}{The width of the line. Defaults to 0.5 (same as standard ggplots)}

\item{colour.by}{One of "arrays" or "sections", defines how the points should be coloured.}

\item{array.alias}{A named vector of format c("old_array_name" = "new_array_name") to replace
default array names with user defined ones. Only relevant if colour.by = "arrays".}

\item{lcol}{The colour for the line. Defaults to grey.}

\item{verbose}{Logical: Should warning messages be printed, if necessary?}
}
\value{
A ggplot object.
}
\description{
The output of plotSensors is a ggplot object, which means you can then use it in combination
with other ggplot functions, or even together with other packages such as patchwork.
}
\examples{
# Using the example results that come with actel
plotSensors(example.results, 'R64K-4451')

# Because plotSensors returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotSensors(example.results, 'R64K-4451')
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
