% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{distancesMatrix}
\alias{distancesMatrix}
\title{Calculate Distances Matrix}
\usage{
distancesMatrix(
  t.layer,
  starters = NULL,
  targets = starters,
  coord.x = "x",
  coord.y = "y",
  id.col = NULL,
  actel = TRUE
)
}
\arguments{
\item{t.layer}{A TransitionLayer object, generated by \code{\link{transitionLayer}}.}

\item{starters}{A data frame with the points from which to start measuring the distance. Ignored if actel = TRUE (default), as the 'spatial.csv' is loaded as starters.}

\item{targets}{A data frame with the points to which a way must be found. Ignored if actel = TRUE (default), as the 'spatial.csv' is loaded as targets.}

\item{coord.x, coord.y}{The names of the columns containing the x and y coordinates in the starters and targets. Must be identical in the starters and targets.}

\item{id.col}{The name of the column containing the IDs of the points to be used as starters and targets. Must be identical in both files. Ignored if actel = TRUE (default), as the stations' standard names are used.}

\item{actel}{Logical: Should the distance matrix be optimized for actel? Defaults to TRUE.}
}
\value{
A matrix with the distances between each pair of points.
}
\description{
Using a previously created transition layer (see \code{\link{transitionLayer}}), calculates the distances
between spatial points. Adapted from Grant Adams' script "distance to closest mpa". if the argument 'actel'
is set to TRUE (default), an actel-compatible matrix is generated, and the user will be asked if they would
like to save the matrix as 'distances.csv' in the current directory.
}
\details{
It is highly recommended to read the vignette regarding distances matrix before running this function.
You can find it by running \code{vignette('a-2_distances_matrix', 'actel')} or \code{browseVignettes('actel')}
}
\examples{
\donttest{
# check if R can run the distance functions
aux <- c(
  length(suppressWarnings(packageDescription("raster"))),
  length(suppressWarnings(packageDescription("gdistance"))),
  length(suppressWarnings(packageDescription("sp"))),
  length(suppressWarnings(packageDescription("tools"))),
  length(suppressWarnings(packageDescription("rgdal"))))
missing.packages <- sapply(aux, function(x) x == 1)

if (any(missing.packages)) {
  message("Sorry, this function requires packages '", 
    paste(c("raster", "gdistance", "sp", "tools", "rgdal")[missing.packages], collapse = "', '"), 
    "' to operate. Please install ", ifelse(sum(missing.packages) > 1, "them", "it"), 
    " before proceeding.")
} else {
  if (suppressWarnings(require("rgdal"))) {
    # move to a temporary directory
    old.wd <- getwd()
    setwd(tempdir())

    # Fetch location of actel's example files
    aux <- system.file(package = "actel")[1]

    # create a temporary spatial.csv file
    file.copy(paste0(aux, "/example_spatial.csv"), "spatial.csv")

    # import the shape file and use the spatial.csv 
    # to check the extents.
    x <- loadShape(path = aux, shape = "example_shapefile.shp", 
      coord.x = "x", coord.y = "y", size = 20)

    # Build the transition layer
    t.layer <- transitionLayer(x)

    # compile the distances matrix. Columns x and y in the spatial dataframe
    # contain the coordinates of the stations and release sites.
    distancesMatrix(t.layer, coord.x = 'x', coord.y = 'y')

    # return to original directory
    setwd(old.wd)
    rm(old.wd)
  } else {
    message("Sorry, it appears that rgdal is not being able to load.")
  }
}
rm(aux, missing.packages)
}

}
