% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_meta.R
\name{search_meta}
\alias{search_meta}
\title{Find names of transcripts and tiers}
\usage{
search_meta(
  x,
  filterTranscriptNames = NULL,
  filterTranscriptIncludeRegEx = NULL,
  filterTranscriptExcludeRegEx = NULL,
  filterTierNames = NULL,
  filterTierIncludeRegEx = NULL,
  filterTierExcludeRegEx = NULL
)
}
\arguments{
\item{x}{Corpus object.}

\item{filterTranscriptNames}{Vector of character strings; Names of the transcripts that you want to include; to include all transcripts in the corpus object leave parameter empty or set to  \code{character()} or \code{""}.}

\item{filterTranscriptIncludeRegEx}{Character string; as regular expression, include transcripts matching the expression.}

\item{filterTranscriptExcludeRegEx}{Character string; as regular expression, exclude transcripts matching the expression.}

\item{filterTierNames}{Vector of character strings; Names of the tiers that you want to include; to include all tiers in the corpus object leave parameter empty or set to  \code{character()} or \code{""}.}

\item{filterTierIncludeRegEx}{Character string; as regular expression, include tiers matching the expression.}

\item{filterTierExcludeRegEx}{Character string; as regular expression, exclude tiers matching the expression.}
}
\value{
List of character vectors. \code{$filterTranscriptNames} contains all transcript names in the corpus matching the expressions, \code{$filterTierNames} contains all tier names in the corpus matching the expressions.
}
\description{
Search a corpus object and return the names of all transcripts and tiers that match the given parameters.
You can define parameters to include and/or exclude transcripts and tiers based on their names.
All parameters that you pass to the function will be combined.
}
\details{
This functions is useful if you want to use functions of the package such as \code{transcripts_update_normalization}, \code{transcripts_update_fulltexts}, \code{corpus_export} and limit them to only some of the transcripts.
}
\examples{
library(act)

# Search all transcripts that have "ARG" (ignoring case sensitivity) in their name
mymeta <- act::search_meta(x=examplecorpus, filterTranscriptIncludeRegEx="(?i)arg")
mymeta$transcripts.names

# Search all transcripts that don't have "ARG" in their name
mymeta <- act::search_meta(x=examplecorpus, filterTranscriptExcludeRegEx="ARG")
mymeta$transcripts.names

# Search all tiers that have an "A" or an "a" in their name
mymeta <- act::search_meta(x=examplecorpus, filterTierIncludeRegEx="(?i)A")
mymeta$tiers.names

# Search all tiers that have a capital "A" in their name
mymeta <- act::search_meta(x=examplecorpus, filterTierIncludeRegEx="A")
mymeta$tiers.names

# In which transcripts do these tiers occur?
mymeta$transcripts.names

# Let's check the first of the transcripts, if this is really the case...
examplecorpus@transcripts[[mymeta$transcripts.names[1]]]@tiers

}
\seealso{
\link{search_new}, \link{search_run}, \link{search_sub}
}
