% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praat.R
\name{praat_search_and_open}
\alias{praat_search_and_open}
\title{Search corpus and open first result in Praat}
\usage{
praat_search_and_open(x, pattern)
}
\arguments{
\item{x}{Corpus object.}

\item{pattern}{Character string; search pattern as regular expression.}
}
\description{
The function remote controls 'Praat' by using 'sendpraat' and a 'Praat' script. 
It first searches your corpus object and uses the first search hit. 
The corresponding TextGrid will be opened in the 'Praat' TextGrid Editor and the search hit will be displayed.
}
\details{
To make this function work you need to set the path to the 'sendpraat' executable using 'options(act.path.sendpraat = ...)'.
}
\examples{
library(act)

# You can only use this functions if you have located the 'sendpraat' executable properly
# in the package options.
\dontrun{
act::praat_search_and_open(x=examplecorpus, "pero")
}



}
