% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_transform_wider.R
\name{acled_transform_wider}
\alias{acled_transform_wider}
\title{Reverse Transform ACLED Data from Long to Wide}
\usage{
acled_transform_wider(data, type = "full_actors")
}
\arguments{
\item{data, }{a dataframe or tibble containing your dataset.}

\item{type, }{a character string. One of five types: full_actors, main_actors, assoc_actors, source, or all.
\itemize{
\item full_actors: All actor and associated actor columns
\item main_actors: Actor 1 and Actor 2 columns
\item assoc_actors: All associated actor columns
\item source: The source column becomes dyadic
\item api_monadic: Use this option for data that is the output of the API's monadic option.
}}
}
\value{
A tibble with the data transformed back into wide form.
}
\description{
Function to convert your ACLED's API calls (if monadic) back into the original dyadic forms.
}
\examples{
\dontrun{
# argen_acled <- acled_api(country = "Argentina",
                           email = "youremail@mail.com", password = "password",
                           start_date = "2022-01-01",
#                          end_date="2022-02-01")
# argen_acled_long_actors <- acled_transform_longer(argen_acled,
#                        type = "full_actor") # Transforming the data to long form

# argen_acled_wide <- acled_transform_wider(argen_acled_long_actors,
#                        type = "full_actor") # Transforming the data back to wide form

# nrow(argen_acled_wide) # Number of rows in the dataset
# [1] 145 # Wide form

# nrow(argen_acled_long_actors) # Number of rows in the dataset
# [1] 263 # Long form
}
}
\seealso{
Other Data Manipulation: 
\code{\link{acled_transform_interaction}()},
\code{\link{acled_transform_longer}()}
}
\concept{Data Manipulation}
