\docType{data}
\name{WalkingStickHeads}
\alias{WalkingStickHeads}
\title{Walking Stick Head Width}
\format{A data frame with 50 observations on the following 2 variables.
\describe{ \item{specimen}{a factor with levels \code{1-25}}
\item{head.width}{a numeric vector} }}
\source{
  Nosil, P. and B.J. Crespi. 2006. Experimental evidence
  that predation promotes divergence in adaptive radiation.
  \emph{Proceedings of the National Academy of Sciences
  (USA)} 103: 9090-9095.
}
\description{
  Two measures of head width (\code{head.width}) for each
  of 25 walking sticks (\emph{Timema cristinae}).
}
\examples{
data(WalkingStickHeads)
aggregate(head.width~specimen, data=WalkingStickHeads, mean) -> WS
histogram(~head.width, WS)
}
\references{
  \url{http://www.sfu.ca/biology/faculty/crespi/pdfs/96-Nosil&Crespi2006PNAS.pdf}
}
\keyword{datasets}

