% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.abclass}
\alias{predict.abclass}
\title{Prediction by A Trained Angle-Based Classifier}
\usage{
\method{predict}{abclass}(
  object,
  newx,
  type = c("class", "probability"),
  selection = c("cv_1se", "cv_min", "all"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{abclass}.}

\item{newx}{A numeric matrix representing the design matrix for predictions.}

\item{type}{A character value specifying the desired type of predictions.
The available options are \code{"class"} for predicted labels and
\code{"probability"} for class conditional probability estimates.}

\item{selection}{An integer vector for the solution indices or a character
value specifying how to select a particular set of coefficient estimates
from the entire solution path for prediction. If the specified
\code{object} contains the cross-validation results, one may set
\code{selection} to \code{"cv_min"} (or \code{"cv_1se"}) for using the
estimates giving the smallest cross-validation error (or the set of
estimates resulted from the largest \emph{lambda} within one standard
error of the smallest cross-validation error) or prediction.  The
prediction for the entire solution path will be returned in a list if
\code{selection = "all"} or no cross-validation results are available in
the specified \code{object}.}

\item{...}{Other arguments not used now.}
}
\value{
A vector representing the predictions or a list containing the
    predictions for each set of estimates along the solution path.
}
\description{
Predict class labels or estimate conditional probabilities for the specified
new data.
}
\examples{
## see examples of `abclass()`.

}
