\name{DEGREE_MEASURE}
\alias{in-degree} 
\alias{out-degree}
\alias{degree-measure}
\alias{DEGREE_MEASURE}
\title{DEGREE_MEASURE, measures the in-degree and out-degree of the 
metabolites in the network.}

\description{this is a simple function to determine the degree measure, 
it uses the fba_object and computes and writes the measures to 
disk as a tab-separated spreadsheet}

\usage{
DEGREE_MEASURE(fba_object,file="Degree_measure")
}

\arguments{
\item{fba_object}{Is a list containing the data required to perform flux
balance analysis. The elements of the list are mat which is the 
stoichiometric matrix, dir which gives the direction of the equality 
constraints, obj specifies the objective function for the simulation, 
bounds specifies the lower and upper inequality constraints, rhs is the 
right hand side of the steady state expression, types refers to the 
numeric nature of the variables which in case of FBA happens to be 
"Continuous", max is a Boolean specifying the type of optimization,
"Maximization" by default, all_genes is all the genes present in the 
model, gpr contains boolean expressions of gene essentiality for the 
corresponding reactions in the model, metabolite_name contains list of 
all the metabolites, reaction_list contains all the reactions present in
the model, compartment is a numeric identifier for each reaction the key
for which is in comp_name.}

\item{file}{a filename for the tab delimited output file which is 
generated by this function}	

}

\examples{
#Determining the Degree Measure of the Core E.coli Metabolic Network
data(Ecoli_core)	
#DEGREE_MEASURE(fba_object=Ecoli_core)
}
