% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setapp.R
\name{setapp}
\alias{setapp}
\title{Sets Application ID and Password}
\usage{
setapp(appdetails = NULL, force = FALSE)
}
\arguments{
\item{appdetails}{A vector of app_id, app_password. Get these from \url{http://ocrsdk.com/}. Set them before you use other functions.}

\item{force}{Force change the app_id and app_password stored in the environment}
}
\description{
Set Application ID and Password. Needed for interfacing with Abbyy FineReader Cloud OCR SDK. Run this before anything else.
}
\details{
The function looks for AbbyyAppId and AbbyyAppPassword in the environment. If it doesn't find them and if we don't want to force
change in them, it looks for arguments. And if no arguments are passed, it asks for user to input the values.
}
\examples{
\dontrun{
setapp(c("app_id", "app_password"))
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/getApplicationInfo/}
}
\keyword{Application}
\keyword{ID}
\keyword{Password}
\keyword{Sets}
\keyword{and}

