% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hyst.R
\name{Hyst}
\alias{Hyst}
\title{HYST (Hybrid Set-based Test) for single trait - pathway association}
\usage{
Hyst(pvec, ldmatrix, snp.info, gene.info)
}
\arguments{
\item{pvec}{p-values for each SNP.}

\item{ldmatrix}{numeric. A correlation matrix of SNPs with dimensions matching the length of pvec (the number of SNPs).}

\item{snp.info}{SNP information matrix, the 1st column is SNP id, 2nd column is chromosome #, 3rd column indicates SNP location.}

\item{gene.info}{GENE information matrix, The 1st column is GENE id, 2nd column is chromosome #, 3rd and 4th column indicate start and end positions of the gene.}
}
\value{
A p-value.
}
\description{
Get a p-value using HYST.
}
\examples{

simula <- simPathAR1Snp(nGenes=20, nGenes1=1, nSNPlim=c(1, 20), nSNP0=1:3,
                           LOR=.2, rholim=c(0,0),
                           n=100, MAFlim=c(0.05, 0.4), p0=0.05)
logitp <- getlogitp(simula$Y, simula$X)

## get correlation of SNPs using controls
ldmat <- cor(simula$X[ simula$Y == 0, ])
out <- Hyst(pvec = logitp, ldmatrix = ldmat, snp.info = simula$snp.info,
            gene.info = simula$gene.info)

}
\author{
Il-Youp Kwak and Wei Pan
}
\references{
Miao-Xin Li, Johnny S.H. Kwan and Pak C. Sham (2012)
HYST: A Hybrid Set-Based Test for Genome-wide Association Studies, with Application to Protein-Protein Interaction-Based Association Analysis
The American Journal of Human Genetics, 91, 478-488.
}
\seealso{
\code{\link{GatesSimes}} \code{\link{GATES2}}
}

