% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_strokes.R
\name{canvas_strokes}
\alias{canvas_strokes}
\title{Paint Random Strokes on a Canvas}
\usage{
canvas_strokes(colors, neighbors = 1, p = 0.01, iterations = 1, 
               width = 500, height = 500, side = FALSE)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{neighbors}{a positive integer specifying the number of neighbors a block considers when taking over a color. More neighbors fades the artwork.}

\item{p}{a value specifying the probability of selecting a new color at each block. A higher probability adds more noise to the artwork.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm. More iterations generally apply more fade to the artwork.}

\item{width}{a positive integer specifying the width of the artwork in pixels.}

\item{height}{a positive integer specifying the height of the artwork in pixels.}

\item{side}{logical. Whether to put the artwork on its side.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function creates an artwork that resembles paints strokes. The algorithm is based on the simple idea that each next point on the grid has a chance to take over the color of an adjacent colored point but also has a change of generating a new color.
}
\examples{
\donttest{
set.seed(16)
palette <- colorPalette('random', n = 6)
canvas_strokes(colors = palette)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
